<?php
if (session_status() == PHP_SESSION_NONE) {
  session_start();
}
include '../config.php';
require 'sidebar.php';

$tanggal_dari = $_GET['tanggal_dari'] ?? '';
$tanggal_sampai = $_GET['tanggal_sampai'] ?? '';

$filter_query = '';
if (!empty($tanggal_dari) && !empty($tanggal_sampai)) {
  $filter_query = "WHERE dibuat_pada BETWEEN '$tanggal_dari' AND '$tanggal_sampai'";
}

$query_pendapatan = $conn->query("SELECT SUM(total_harga) as total FROM transaksi $filter_query");
$total_pendapatan = $query_pendapatan->fetch_assoc()['total'] ?? 0;

$jumlah_produk = $conn->query("SELECT COUNT(*) as total FROM produk")->fetch_assoc()['total'];
$jumlah_transaksi = $conn->query("SELECT COUNT(*) as total FROM transaksi")->fetch_assoc()['total'];
$jumlah_kategori = $conn->query("SELECT COUNT(*) as total FROM kategori_produk")->fetch_assoc()['total'];
$jumlah_diskon = $conn->query("SELECT COUNT(*) as total FROM diskon")->fetch_assoc()['total'];
$jumlah_pelanggan = $conn->query("SELECT COUNT(*) as total FROM pengguna WHERE peran = 'pelanggan'")->fetch_assoc()['total'];
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<div class="content p-4">
  <h2 class="mb-4 fw-semibold text-dark">Halo, <?= $_SESSION['nama']; ?> 👋</h2>
  <p class="mb-4 text-muted">Selamat datang di Dashboard Admin.</p>

  <!-- Card Total Pendapatan + Filter -->
  <div class="card bg-light shadow-sm border-0 rounded-4 mb-4">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div class="d-flex align-items-center gap-3">
          <div class="icon-wrapper bg-success bg-opacity-10 text-success rounded-3 p-3">
            <i class="bi bi-currency-dollar fs-3"></i>
          </div>
          <div>
            <h6 class="mb-0 text-muted">Total Pendapatan</h6>
            <h4 class="fw-semibold text-dark mb-0">Rp <?= number_format($total_pendapatan, 0, ',', '.'); ?></h4>
          </div>
        </div>
      </div>

      <form method="get" class="row g-2">
        <div class="col-md-5">
          <label class="form-label">Dari</label>
          <input type="date" class="form-control" name="tanggal_dari" value="<?= htmlspecialchars($tanggal_dari) ?>">
        </div>
        <div class="col-md-5">
          <label class="form-label">Sampai</label>
          <input type="date" class="form-control" name="tanggal_sampai" value="<?= htmlspecialchars($tanggal_sampai) ?>">
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button type="submit" class="btn btn-primary w-100"><i class="bi bi-funnel-fill me-1"></i> Filter</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Kartu Statistik Lainnya -->
  <div class="row g-4">
    <?php
    $cards = [
      ['label' => 'Produk', 'icon' => 'box-seam', 'value' => $jumlah_produk],
      ['label' => 'Transaksi', 'icon' => 'cash-stack', 'value' => $jumlah_transaksi],
      ['label' => 'Kategori', 'icon' => 'tags', 'value' => $jumlah_kategori],
      ['label' => 'Diskon', 'icon' => 'percent', 'value' => $jumlah_diskon],
      ['label' => 'Pelanggan', 'icon' => 'people', 'value' => $jumlah_pelanggan],
    ];
    foreach ($cards as $card) :
    ?>
      <div class="col-md-4">
        <div class="card bg-light shadow-sm border-0 rounded-4 h-100">
          <div class="card-body d-flex align-items-center gap-3">
            <div class="icon-wrapper bg-primary bg-opacity-10 text-primary rounded-3 p-3">
              <i class="bi bi-<?= $card['icon']; ?> fs-3"></i>
            </div>
            <div>
              <h6 class="mb-0 text-muted"><?= $card['label']; ?></h6>
              <h4 class="fw-semibold text-dark"><?= $card['value']; ?></h4>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<style>
  .card {
    transition: all 0.3s ease-in-out;
  }

  .card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
  }

  .icon-wrapper {
    width: 56px;
    height: 56px;
    display: flex;
    align-items: center;
    justify-content: center;
  }
</style>