<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require '../config.php';
require '../admin/sidebar.php'; // Ensure this path is correct based on your file structure

$id = $_SESSION['user_id'];

// Use a prepared statement to fetch admin profile data securely
$stmt = $conn->prepare("SELECT * FROM pengguna WHERE id = ? AND peran = 'admin'");
if ($stmt === false) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

// If admin data not found, redirect to login
if (!$data) {
    header("Location: ../login.php");
    exit;
}

$stmt->close(); // Close the statement

// Handle alerts from previous operations (e.g., proses_update_profil_admin.php or proses_ubah_password.php)
// Make sure those files set $_SESSION['alert'] like this:
// $_SESSION['alert'] = ['type' => 'success', 'message' => 'Profil berhasil diperbarui.'];
// $_SESSION['alert'] = ['type' => 'danger', 'message' => 'Password lama salah.'];
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Admin - Day Apparel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f6;
            /* Light gray background */
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }

        /* Content wrapper styles from other admin pages */
        #page-content-wrapper {
            flex-grow: 1;
            padding: 30px;
            background-color: #ffffff;
            /* White content background */
            border-radius: 12px;
            /* Softly rounded corners */
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
            /* Subtle shadow */
            margin: 20px;
            /* Margin around the content area */
        }

        .main-header {
            font-size: 2.2rem;
            font-weight: 700;
            color: #2c3e50;
            /* Darker title color */
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eee;
            /* Subtle separator */
            text-align: center;
        }

        /* Form Styling */
        .form-control,
        .form-select {
            border-radius: 8px;
            /* Rounded input/select fields */
            padding: 10px 15px;
            border: 1px solid #ddd;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: #34495e;
            /* Highlight border on focus */
            box-shadow: 0 0 0 0.25rem rgba(52, 73, 94, 0.25);
        }

        label {
            font-weight: 500;
            color: #555;
            margin-bottom: 8px;
            /* More space for labels */
            display: block;
            /* Ensure label takes full width */
            font-size: 0.95em;
        }

        /* Button Styling */
        .btn-primary {
            background-color: #34495e;
            /* Darker blue/gray primary */
            border-color: #34495e;
            transition: all 0.3s ease;
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 8px;
            /* Rounded buttons */
        }

        .btn-primary:hover {
            background-color: #2c3e50;
            border-color: #2c3e50;
            transform: translateY(-2px);
            /* Slight lift on hover */
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .btn-warning {
            background-color: #f39c12;
            /* Flat orange for warning */
            border-color: #f39c12;
            color: #fff;
            font-weight: 500;
            border-radius: 8px;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }

        .btn-warning:hover {
            background-color: #e67e22;
            border-color: #e67e22;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .btn-secondary {
            background-color: #bdc3c7;
            /* Light gray for secondary actions */
            border-color: #bdc3c7;
            color: #fff;
            font-weight: 500;
            border-radius: 8px;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }

        .btn-secondary:hover {
            background-color: #95a5a6;
            border-color: #95a5a6;
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        /* Alert Styling */
        .alert {
            border-radius: 8px;
            /* Rounded alert corners */
            font-size: 1.05em;
            padding: 15px 20px;
            margin-bottom: 25px;
            /* Space below alert */
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
        }

        .alert-warning {
            background-color: #fff3cd;
            color: #856404;
            border-color: #ffeeba;
        }

        .alert .btn-close {
            font-size: 0.9em;
        }

        /* Modal Styling */
        .modal-content {
            border-radius: 12px;
            /* Rounded modal corners */
            border: none;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
        }

        .modal-header {
            background-color: #f8f9fa;
            /* Light header */
            border-bottom: 1px solid #e9ecef;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
            padding: 20px;
        }

        .modal-header h5 {
            color: #34495e;
            /* Dark title */
            font-weight: 600;
            font-size: 1.5rem;
        }

        .modal-body {
            padding: 25px;
        }

        .modal-footer {
            border-top: 1px solid #e9ecef;
            padding: 15px 25px;
            border-bottom-left-radius: 12px;
            border-bottom-right-radius: 12px;
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php // The sidebar.php content is included here 
        ?>
        <div id="page-content-wrapper">
            <div class="container-fluid">
                <h3 class="main-header">Profil Admin</h3>

                <?php if (isset($_SESSION['alert'])): ?>
                    <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show" role="alert">
                        <i class="fas fa-info-circle me-2"></i> <?= $_SESSION['alert']['message'] ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php unset($_SESSION['alert']); ?>
                <?php endif; ?>

                <form method="POST" action="../proses/proses_update_profil_admin.php" class="p-4 rounded shadow-sm bg-light">
                    <input type="hidden" name="id" value="<?= htmlspecialchars($data['id']) ?>">

                    <div class="mb-3">
                        <label for="nama" class="form-label">Nama Lengkap</label>
                        <input type="text" name="nama" id="nama" class="form-control" value="<?= htmlspecialchars($data['nama']) ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" name="email" id="email" class="form-control" value="<?= htmlspecialchars($data['email']) ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                        <select name="jenis_kelamin" id="jenis_kelamin" class="form-select" required>
                            <option value="L" <?= ($data['jenis_kelamin'] ?? '') == 'L' ? 'selected' : '' ?>>Laki-laki</option>
                            <option value="P" <?= ($data['jenis_kelamin'] ?? '') == 'P' ? 'selected' : '' ?>>Perempuan</option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="no_telp" class="form-label">No. Telepon</label>
                        <input type="text" name="no_telp" id="no_telp" value="<?= htmlspecialchars($data['no_telp'] ?? '') ?>" class="form-control" placeholder="Opsional">
                    </div>

                    <button class="btn btn-primary me-2" type="submit">
                        <i class="fas fa-save me-2"></i> Simpan Perubahan
                    </button>
                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#modalUbahPassword">
                        <i class="fas fa-key me-2"></i> Ubah Password
                    </button>
                </form>

                <a href="dashboard.php" class="btn btn-secondary mt-4">
                    <i class="fas fa-arrow-left me-2"></i> Kembali ke Dashboard
                </a>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalUbahPassword" tabindex="-1" aria-labelledby="modalUbahPasswordLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form method="POST" action="../proses/proses_ubah_password.php" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalUbahPasswordLabel">Ubah Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="password_lama" class="form-label">Password Lama</label>
                        <input type="password" name="password_lama" id="password_lama" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="password_baru" class="form-label">Password Baru</label>
                        <input type="password" name="password_baru" id="password_baru" class="form-control" required pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}" title="Harus mengandung setidaknya satu angka, satu huruf kapital, satu huruf kecil, dan minimal 8 karakter atau lebih">
                        <small class="form-text text-muted">Minimal 8 karakter, termasuk huruf kapital, huruf kecil, dan angka.</small>
                    </div>
                    <div class="mb-3">
                        <label for="konfirmasi_password" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" name="konfirmasi_password" id="konfirmasi_password" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Batal</button>
                    <button class="btn btn-primary" type="submit"><i class="fas fa-save me-2"></i> Simpan Password</button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>