<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require '../admin_helper.php';

// Database connection
require '../../config.php';

// Handle approval/rejection actions
if (isset($_POST['action']) && isset($_POST['review_id'])) {
    $review_id = intval($_POST['review_id']);
    $action = $_POST['action'];

    if ($action === 'approve') {
        $stmt = $conn->prepare("UPDATE ulasan_produk SET status = 'approved' WHERE id = ?");
    } elseif ($action === 'reject') {
        $stmt = $conn->prepare("UPDATE ulasan_produk SET status = 'rejected' WHERE id = ?");
    } elseif ($action === 'delete') {
        $stmt = $conn->prepare("DELETE FROM ulasan_produk WHERE id = ?");
    }

    if (isset($stmt)) {
        $stmt->bind_param("i", $review_id);
        $stmt->execute();
        $stmt->close();
    }

    // Redirect to prevent form resubmission
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Fetch reviews with status
$query = "
    SELECT r.*, p.nama as nama_produk, u.nama as nama_pengguna
    FROM ulasan_produk r
    JOIN produk p ON r.id_produk = p.id
    JOIN pengguna u ON r.id_pelanggan = u.id
    ORDER BY 
        CASE r.status 
            WHEN 'pending' THEN 1 
            WHEN 'approved' THEN 2 
            WHEN 'rejected' THEN 3 
        END,
        r.tanggal_ulasan DESC
";

$stmt = $conn->prepare($query);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
$stmt->execute();
$result = $stmt->get_result();

// Count reviews by status
$status_counts = [];
$count_query = "SELECT status, COUNT(*) as count FROM ulasan_produk GROUP BY status";
$count_result = $conn->query($count_query);
while ($row = $count_result->fetch_assoc()) {
    $status_counts[$row['status']] = $row['count'];
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Ulasan - Day Apparel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 0;
        }

        .review-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .star-display {
            font-size: 1.1rem;
        }

        .action-buttons {
            gap: 8px;
        }

        .btn-action {
            margin: 2px;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            text-decoration: none;
            display: inline-block;
            min-width: 80px;
            text-align: center;
        }

        .btn-approve {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
        }

        .btn-approve:hover {
            background: linear-gradient(135deg, #218838, #1aa085);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
            color: white;
            text-decoration: none;
        }

        .btn-reject {
            background: linear-gradient(135deg, #dc3545, #fd7e14);
            color: white;
        }

        .btn-reject:hover {
            background: linear-gradient(135deg, #c82333, #e8690b);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
            color: white;
            text-decoration: none;
        }

        .btn-delete {
            background: linear-gradient(135deg, #6c757d, #adb5bd);
            color: white;
        }

        .btn-delete:hover {
            background: linear-gradient(135deg, #5a6268, #95a0a8);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
            color: white;
            text-decoration: none;
        }

        /* Fix untuk mencegah padding issues */
        .btn-action:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 123, 255, .25);
        }

        .btn-action:active {
            transform: translateY(0);
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        /* Pastikan container tidak berubah setelah action */
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .table {
            margin-bottom: 0;
        }

        /* Content berbatasan dengan sidebar - tidak overlap */
        .container-fluid {
            padding-left: 15px !important;
            padding-right: 15px !important;
            margin-left: 0 !important;
            margin-right: 0 !important;
        }

        /* Row tanpa gutter kiri berlebihan */
        .row {
            margin-left: 0 !important;
            margin-right: -15px !important;
        }

        /* Column minimal padding kiri */
        .col-12 {
            padding-left: 15px !important;
            padding-right: 15px !important;
        }

        /* Card berbatasan dengan sidebar */
        .card {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }

        /* Table responsive dengan jarak minimal dari sidebar */
        .table-responsive {
            margin-left: 0 !important;
            padding-left: 0 !important;
        }

        /* Main content berbatasan dengan sidebar */
        .main-content,
        .content,
        [class*="content"] {
            padding-left: 15px !important;
            margin-left: 10 !important;
        }

        /* Untuk admin layout wrapper */
        .content-wrapper,
        .main-wrapper,
        .page-wrapper {
            padding-left: 15px !important;
            margin-left: 0 !important;
        }

        /* Card body dengan padding yang pas */
        .card-header,
        .card-body {
            padding-left: 15px !important;
            padding-right: 15px !important;
        }

        /* Pastikan tidak ada space berlebihan */
        .table {
            margin-left: 0 !important;
        }

        .status-pending {
            background: linear-gradient(135deg, #ffc107, #fd7e14);
            color: #000;
            font-weight: 600;
            box-shadow: 0 2px 4px rgba(255, 193, 7, 0.3);
        }

        .status-approved {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            font-weight: 600;
            box-shadow: 0 2px 4px rgba(40, 167, 69, 0.3);
        }

        .status-rejected {
            background: linear-gradient(135deg, #dc3545, #fd7e14);
            color: white;
            font-weight: 600;
            box-shadow: 0 2px 4px rgba(220, 53, 69, 0.3);
        }

        .pulse-animation {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }
    </style>
</head>

<body>
    <?php include '../sidebar.php'; ?>

    <div class="container-fluid" style="margin-left: 250px;">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-star text-warning me-2"></i>Kelola Ulasan Produk</h2>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-warning"><?= $status_counts['pending'] ?? 0 ?></h3>
                        <p class="mb-0">Pending Review</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-success"><?= $status_counts['approved'] ?? 0 ?></h3>
                        <p class="mb-0">Approved</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-danger"><?= $status_counts['rejected'] ?? 0 ?></h3>
                        <p class="mb-0">Rejected</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-info"><?= array_sum($status_counts) ?></h3>
                        <p class="mb-0">Total Reviews</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Reviews List -->
        <div class="row">
            <?php if ($result->num_rows > 0): ?>
                <?php while ($review = $result->fetch_assoc()): ?>
                    <div class="col-12">
                        <div class="review-card">
                            <div class="row">
                                <div class="col-12">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div class="product-info">
                                            <h6 class="mb-1">
                                                <i class="fas fa-box me-2 text-primary"></i>
                                                <?= htmlspecialchars($review['nama_produk']) ?>
                                            </h6>
                                            <div class="text-muted small">
                                                <i class="fas fa-user me-1"></i>
                                                <?= htmlspecialchars($review['nama_pengguna']) ?>
                                            </div>
                                        </div>
                                        <div class="text-muted small">
                                            <i class="fas fa-calendar me-1"></i>
                                            <?= date('d/m/Y H:i', strtotime($review['tanggal_ulasan'])) ?>
                                        </div>
                                    </div>

                                    <div class="star-display mb-2">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star<?= $i <= $review['rating'] ? '' : ' text-muted' ?>"
                                                style="<?= $i <= $review['rating'] ? 'color: #ffc107;' : 'color: #dee2e6;' ?>"></i>
                                        <?php endfor; ?>
                                        <span class="ms-2 fw-bold">(<?= $review['rating'] ?>/5)</span>
                                    </div>

                                    <div class="review-content">
                                        <p class="mb-3"><?= nl2br(htmlspecialchars($review['isi_ulasan'])) ?></p>
                                    </div>

                                    <!-- Status and Actions -->
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                        <div>
                                            <?php
                                            $status_class = '';
                                            $status_text = '';
                                            $status_icon = '';
                                            switch ($review['status']) {
                                                case 'pending':
                                                    $status_class = 'status-pending pulse-animation';
                                                    $status_text = 'Menunggu Review';
                                                    $status_icon = 'fas fa-clock';
                                                    break;
                                                case 'approved':
                                                    $status_class = 'status-approved';
                                                    $status_text = 'Disetujui';
                                                    $status_icon = 'fas fa-check-circle';
                                                    break;
                                                case 'rejected':
                                                    $status_class = 'status-rejected';
                                                    $status_text = 'Ditolak';
                                                    $status_icon = 'fas fa-times-circle';
                                                    break;
                                            }
                                            ?>
                                            <span class="badge <?= $status_class ?> px-3 py-2">
                                                <i class="<?= $status_icon ?> me-2"></i><?= $status_text ?>
                                            </span>
                                        </div>

                                        <div class="d-flex action-buttons">
                                            <?php if ($review['status'] !== 'approved'): ?>
                                                <form method="POST" style="display: inline;">
                                                    <input type="hidden" name="review_id" value="<?= $review['id'] ?>">
                                                    <input type="hidden" name="action" value="approve">
                                                    <button type="submit" class="btn btn-approve btn-action"
                                                        onclick="return confirm('Setujui ulasan ini untuk ditampilkan di halaman produk?')"
                                                        title="Setujui Ulasan">
                                                        <i class="fas fa-thumbs-up me-2"></i>Setujui
                                                    </button>
                                                </form>
                                            <?php endif; ?>

                                            <?php if ($review['status'] !== 'rejected'): ?>
                                                <form method="POST" style="display: inline;">
                                                    <input type="hidden" name="review_id" value="<?= $review['id'] ?>">
                                                    <input type="hidden" name="action" value="reject">
                                                    <button type="submit" class="btn btn-reject btn-action"
                                                        onclick="return confirm('Tolak ulasan ini? Ulasan tidak akan ditampilkan di halaman produk.')"
                                                        title="Tolak Ulasan">
                                                        <i class="fas fa-thumbs-down me-2"></i>Tolak
                                                    </button>
                                                </form>
                                            <?php endif; ?>

                                            <form method="POST" style="display: inline;">
                                                <input type="hidden" name="review_id" value="<?= $review['id'] ?>">
                                                <input type="hidden" name="action" value="delete">
                                                <button type="submit" class="btn btn-delete btn-action"
                                                    onclick="return confirm('Hapus ulasan ini secara permanen? Tindakan ini tidak dapat dibatalkan!')"
                                                    title="Hapus Permanen">
                                                    <i class="fas fa-trash-alt me-2"></i>Hapus
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        <i class="fas fa-info-circle me-2"></i>
                        Tidak ada ulasan ditemukan.
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>