<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - Day Apparel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container-fluid vh-100 d-flex align-items-center justify-content-center">
  <div class="row w-100 justify-content-center">
    <div class="col-11 col-sm-8 col-md-6 col-lg-4 col-xl-3">
      
      <!-- Brand Logo/Name -->
      <div class="text-center mb-4">
        <h2 class="fw-bold text-dark mb-1">Day Apparel</h2>
        <p class="text-muted small">Masuk ke akun Anda</p>
      </div>

      <!-- Alert Messages -->
      <div id="alert-container">
        <!-- PHP alerts will be displayed here -->
        <?php
        if (isset($_GET['pesan'])) {
          if ($_GET['pesan'] == 'gagal') {
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>Email atau password salah!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                  </div>';
          } elseif ($_GET['pesan'] == 'daftar_sukses') {
            echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>Berhasil daftar! Silakan login.
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                  </div>';
          } elseif ($_GET['pesan'] == 'logout') {
            echo '<div class="alert alert-info alert-dismissible fade show" role="alert">
                    <i class="fas fa-info-circle me-2"></i>Anda telah logout.
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                  </div>';
          }
        }
        ?>
      </div>

      <!-- Login Card -->
      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          
          <form action="../day.apparel/proses/proses_pelanggan_login.php" method="POST">
            
            <!-- Email Input -->
            <div class="mb-3">
              <label for="email" class="form-label fw-medium text-dark">Email</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-envelope text-muted"></i>
                </span>
                <input type="email" 
                       name="email" 
                       id="email"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Masukkan email Anda"
                       required>
              </div>
            </div>

            <!-- Password Input -->
            <div class="mb-4">
              <label for="password" class="form-label fw-medium text-dark">Password</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-lock text-muted"></i>
                </span>
                <input type="password" 
                       name="password" 
                       id="password"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Masukkan password Anda"
                       required>
                <button class="btn btn-outline-secondary border-start-0" 
                        type="button" 
                        id="togglePassword">
                  <i class="fas fa-eye" id="eyeIcon"></i>
                </button>
              </div>
            </div>

            <!-- Login Button -->
            <div class="d-grid mb-3">
              <button type="submit" class="btn btn-dark py-2 fw-medium">
                <i class="fas fa-sign-in-alt me-2"></i>Masuk
              </button>
            </div>

          </form>

          <!-- Divider -->
          <div class="text-center mb-3">
            <hr class="my-3">
          </div>

          <!-- Action Links -->
          <div class="text-center">
            <p class="mb-2">
              <a href="../day.apparel/register.php" 
                 class="text-decoration-none fw-medium">
                Belum punya akun? <span class="text-primary">Daftar di sini</span>
              </a>
            </p>
            <p class="mb-0">
              <a href="../day.apparel/lupa_password.php" 
                 class="text-muted text-decoration-none small">
                <i class="fas fa-question-circle me-1"></i>Lupa Password?
              </a>
            </p>
          </div>

        </div>
      </div>

      <!-- Footer -->
      <div class="text-center mt-4">
        <p class="text-muted small mb-0">
          © 2025 Day Apparel. All rights reserved.
        </p>
      </div>

    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Toggle Password Visibility -->
<script>
document.getElementById('togglePassword').addEventListener('click', function () {
  const password = document.getElementById('password');
  const eyeIcon = document.getElementById('eyeIcon');
  
  if (password.type === 'password') {
    password.type = 'text';
    eyeIcon.classList.remove('fa-eye');
    eyeIcon.classList.add('fa-eye-slash');
  } else {
    password.type = 'password';
    eyeIcon.classList.remove('fa-eye-slash');
    eyeIcon.classList.add('fa-eye');
  }
});
</script>

</body>
</html>