<?php
require '../config.php';
session_start();
require '../pelanggan/navbar.php';

if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$user_id = $_SESSION['user_id'];
$pengguna = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM pengguna WHERE id = $user_id"));
$keranjang = mysqli_query($conn, "
      SELECT 
        k.*, 
        p.nama, 
        p.harga, 
        p.gambar,
        up.ukuran,
        up.stok AS stok_ukuran
    FROM keranjang k 
    JOIN produk p ON k.produk_id = p.id 
    JOIN ukuran_produk up ON k.ukuran_id = up.id
    WHERE k.pengguna_id = $user_id
");

$total_harga = 0;
$keranjang_data = [];
$ongkir = 20000;

while ($item = mysqli_fetch_assoc($keranjang)) {
  $subtotal = $item['harga'] * $item['jumlah'];
  $total_harga += $subtotal;
  $keranjang_data[] = $item + ['subtotal' => $subtotal];
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <title>Checkout</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      /* background: linear-gradient(135deg, #000000 0%, #1a1a1a 25%, #333333 50%, #666666 75%, #ffffff 100%); */
      min-height: 100vh;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .checkout-container {
      background: rgba(255, 255, 255, 0.98);
      backdrop-filter: blur(20px);
      border-radius: 25px;
      box-shadow:
        0 25px 50px rgba(0, 0, 0, 0.4),
        inset 0 1px 0 rgba(255, 255, 255, 0.9);
      padding: 2.5rem;
      margin: 2rem auto;
      max-width: 1200px;
      border: 2px solid rgba(0, 0, 0, 0.15);
    }

    .page-title {
      background: linear-gradient(135deg, #000000 0%, #434343 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      font-size: 2.5rem;
      font-weight: 700;
      text-align: center;
      margin-bottom: 2rem;
      position: relative;
    }

    .page-title::after {
      content: '';
      position: absolute;
      bottom: -10px;
      left: 50%;
      transform: translateX(-50%);
      width: 80px;
      height: 3px;
      background: linear-gradient(135deg, #000000 0%, #666666 100%);
      border-radius: 2px;
    }

    .card {
      border: 2px solid #333333;
      border-radius: 20px;
      box-shadow:
        0 15px 35px rgba(0, 0, 0, 0.2),
        inset 0 1px 0 rgba(255, 255, 255, 0.8);
      background:
        linear-gradient(135deg, rgba(255, 255, 255, 0.98) 0%, rgba(245, 245, 245, 0.98) 100%);
      backdrop-filter: blur(15px);
      transition: all 0.3s ease;
      overflow: hidden;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow:
        0 25px 45px rgba(0, 0, 0, 0.3),
        inset 0 1px 0 rgba(255, 255, 255, 0.9);
      border-color: #000000;
    }

    .card-header {
      background: linear-gradient(135deg, #000000 0%, #434343 100%);
      color: white;
      border: none;
      padding: 1.5rem;
      position: relative;
      overflow: hidden;
    }

    .card-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="white" opacity="0.1"/><circle cx="80" cy="30" r="1.5" fill="white" opacity="0.15"/></svg>');
      pointer-events: none;
    }

    .card-header h5 {
      margin: 0;
      font-weight: 600;
      position: relative;
      z-index: 1;
    }

    .table {
      background: transparent;
      border-radius: 15px;
      overflow: hidden;
    }

    .table thead th {
      background: linear-gradient(135deg, #000000 0%, #333333 100%);
      border: none;
      color: #ffffff;
      font-weight: 700;
      padding: 1rem 0.75rem;
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .table tbody td {
      border: none;
      padding: 1rem 0.75rem;
      vertical-align: middle;
      background: rgba(255, 255, 255, 0.95);
      color: #000000;
      font-weight: 500;
    }

    .table tbody tr {
      border-bottom: 1px solid rgba(0, 0, 0, 0.15);
    }

    .table tbody tr:hover {
      background: rgba(0, 0, 0, 0.05);
    }

    .table tfoot th {
      background: linear-gradient(135deg, #000000 0%, #434343 100%);
      color: white;
      border: none;
      padding: 1rem 0.75rem;
      font-weight: 700;
    }

    .form-control {
      border: 2px solid #333333;
      border-radius: 12px;
      padding: 0.75rem 1rem;
      transition: all 0.3s ease;
      background: rgba(255, 255, 255, 0.98);
      color: #000000;
    }

    .form-control:focus {
      border-color: #000000;
      box-shadow: 0 0 0 0.2rem rgba(0, 0, 0, 0.2);
      background: white;
    }

    .form-control[readonly] {
      background: linear-gradient(135deg, #f0f0f0 0%, #d9d9d9 100%);
      border-color: #666666;
      color: #333333;
    }

    .form-label {
      font-weight: 700;
      color: #000000;
      margin-bottom: 0.5rem;
      text-transform: uppercase;
      font-size: 0.85rem;
      letter-spacing: 0.5px;
    }

    .metode-card {
      border: 2px solid #333333;
      border-radius: 16px;
      padding: 1.5rem 1rem;
      text-align: center;
      cursor: pointer;
      transition: all 0.3s ease;
      background:
        linear-gradient(135deg, rgba(255, 255, 255, 0.98) 0%, rgba(245, 245, 245, 0.98) 100%);
      min-height: 120px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      position: relative;
      overflow: hidden;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .metode-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);
      transition: all 0.5s;
    }

    .metode-card:hover::before {
      left: 100%;
    }

    .metode-card:hover {
      transform: translateY(-3px);
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.25);
      border-color: #000000;
    }

    .metode-card.selected {
      border-color: #000000;
      background: linear-gradient(135deg, rgba(0, 0, 0, 0.1) 0%, rgba(50, 50, 50, 0.1) 100%);
      transform: translateY(-3px);
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
    }

    .metode-card img {
      width: 60px;
      height: 40px;
      margin-bottom: 8px;
      object-fit: contain;
      filter: grayscale(80%) contrast(120%);
      transition: filter 0.3s ease;
    }

    .metode-card:hover img,
    .metode-card.selected img {
      filter: grayscale(0%) contrast(110%);
    }

    .metode-card div {
      font-weight: 700;
      color: #000000;
      font-size: 0.9rem;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .btn-primary {
      background: linear-gradient(135deg, #000000 0%, #434343 100%);
      border: none;
      border-radius: 12px;
      padding: 1rem 2rem;
      font-weight: 700;
      font-size: 1.1rem;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
      text-transform: uppercase;
      letter-spacing: 1px;
    }

    .btn-primary::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
      transition: all 0.5s;
    }

    .btn-primary:hover::before {
      left: 100%;
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
      background: linear-gradient(135deg, #2c2c2c 0%, #000000 100%);
    }

    .address-card {
      background: linear-gradient(135deg, #f5f5f5 0%, #e0e0e0 100%);
      border-radius: 15px;
      padding: 1.5rem;
      margin-bottom: 1.5rem;
      border-left: 4px solid #000000;
      border: 2px solid #333333;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .total-summary {
      background: linear-gradient(135deg, #000000 0%, #434343 100%);
      color: white;
      border-radius: 15px;
      padding: 2rem;
      margin-top: 1rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .total-summary::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="white" opacity="0.05"/><circle cx="80" cy="30" r="1.5" fill="white" opacity="0.08"/></svg>');
      pointer-events: none;
    }

    .badge {
      background: #000000 !important;
      color: white !important;
      border-radius: 8px;
      padding: 0.5rem 1rem;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      border: 1px solid #333333;
    }

    .text-success {
      color: #000000 !important;
      font-weight: 700;
    }

    .text-primary {
      color: #000000 !important;
      font-weight: 700;
    }

    .alert-info {
      background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%) !important;
      border: 2px solid #000000 !important;
      color: #000000 !important;
      border-radius: 15px !important;
    }

    @media (max-width: 768px) {
      .checkout-container {
        margin: 1rem;
        padding: 1.5rem;
      }

      .page-title {
        font-size: 2rem;
      }

      .metode-card {
        min-height: 100px;
        padding: 1rem 0.5rem;
      }

      .total-summary {
        padding: 1.5rem;
      }
    }

    .fade-in {
      animation: fadeIn 0.6s ease-in;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(20px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Additional black and white touches */
    .btn-light {
      background: white !important;
      color: #000000 !important;
      border: 2px solid #000000 !important;
      font-weight: 700 !important;
      text-transform: uppercase !important;
      letter-spacing: 0.5px !important;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2) !important;
    }

    .btn-light:hover {
      background: #000000 !important;
      color: white !important;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.4) !important;
    }

    .bg-secondary {
      background: #333333 !important;
      color: white !important;
    }

    .bg-info {
      background: #000000 !important;
    }

    /* Enhanced monochrome theme */
    .table tfoot th {
      background: linear-gradient(135deg, #000000 0%, #333333 100%);
      color: white;
      border: none;
      padding: 1rem 0.75rem;
      font-weight: 700;
    }

    .card-header {
      background: linear-gradient(135deg, #000000 0%, #333333 100%);
      color: white;
      border: none;
      padding: 1.5rem;
      position: relative;
      overflow: hidden;
      border-bottom: 2px solid #000000;
    }

    .total-summary {
      background: linear-gradient(135deg, #000000 0%, #333333 100%);
      color: white;
      border-radius: 15px;
      padding: 2rem;
      margin-top: 1rem;
      text-align: center;
      position: relative;
      overflow: hidden;
      border: 2px solid #000000;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
    }
  </style>
</head>

<body>
  <div class="container-fluid">
    <div class="checkout-container fade-in">
      <h1 class="page-title">
        <i class="fas fa-shopping-cart me-3"></i>Checkout Pesanan
      </h1>

      <form action="../proses/proses_checkout.php" method="POST" enctype="multipart/form-data">
        <div class="row g-4">

          <!-- Detail Produk -->
          <div class="col-lg-7">
            <div class="card">
              <div class="card-body p-0">
                <div class="table-responsive">
                  <table class="table align-middle mb-0">
                    <thead>
                      <tr>
                        <th><i class="fas fa-tag me-me"></i>Produk</th>
                        <th><i class="fas fa-expand-arrows-alt me-1"></i>Ukuran</th>
                        <th><i class="fas fa-money-bill-wave me-1"></i>Harga</th>
                        <th><i class="fas fa-sort-numeric-up me-1"></i>Jumlah</th>
                        <th><i class="fas fa-calculator me-1"></i>Subtotal</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($keranjang_data as $item): ?>
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <i class="fas fa-tshirt text-primary me-2"></i>
                              <strong><?= htmlspecialchars($item['nama']) ?></strong>
                            </div>
                          </td>
                          <td><span class="badge bg-secondary"><?= htmlspecialchars($item['ukuran']) ?></span></td>
                          <td><span class="text-success fw-bold">Rp<?= number_format($item['harga']) ?></span></td>
                          <td><span class="badge bg-info"><?= $item['jumlah'] ?></span></td>
                          <td><span class="text-primary fw-bold">Rp<?= number_format($item['subtotal']) ?></span></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                      <tr>
                        <th colspan="4" class="text-end"><i class="fas fa-shopping-bag me-2"></i>Total Belanja</th>
                        <th><i class="fas fa-coins me-2"></i>Rp<?= number_format($total_harga) ?></th>
                      </tr>
                      <tr>
                        <th colspan="4" class="text-end"><i class="fas fa-truck me-2"></i>Ongkos Kirim - jne</th>
                        <th><i class="fas fa-coins me-2"></i>Rp<?= number_format($ongkir) ?></th>
                      </tr>
                      <tr>
                        <th colspan="4" class="text-end"><i class="fas fa-receipt me-2"></i>Total Pembayaran</th>
                        <th><i class="fas fa-money-check-alt me-2"></i>Rp<?= number_format($total_harga + $ongkir) ?></th>
                      </tr>
                    </tfoot>
                  </table>
                </div>
                <input type="hidden" name="total_harga" value="<?= $total_harga ?>">
              </div>
            </div>
          </div>

          <!-- Alamat & Pembayaran -->
          <div class="col-lg-5">
            <!-- Alamat Pengiriman -->
            <div class="card mb-4">
              <div class="card-header">
                <h5><i class="fas fa-map-marker-alt me-2"></i>Alamat Pengiriman</h5>
              </div>
              <div class="card-body">
                <div class="address-card">
                  <div class="mb-3">
                    <label class="form-label"><i class="fas fa-user me-1"></i>Nama Penerima</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($pengguna['nama']) ?>" readonly>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><i class="fas fa-phone me-1"></i>No. Telepon</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($pengguna['no_telp']) ?>" readonly>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><i class="fas fa-home me-1"></i>Alamat Lengkap</label>
                    <textarea class="form-control" rows="3" readonly><?= htmlspecialchars($pengguna['alamat_lengkap']) ?>,
<?= $pengguna['kelurahan'] ?>, <?= $pengguna['kecamatan'] ?>, <?= $pengguna['kabupaten_kota'] ?>, <?= $pengguna['provinsi'] ?></textarea>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><i class="fas fa-shipping-fast me-1"></i>Ongkos Kirim</label>
                    <input type="text" class="form-control" value="Rp<?= number_format($ongkir) ?>" readonly>
                  </div>
                  <div class="mb-0">
                    <label class="form-label"><i class="fas fa-percentage me-1"></i>Kode Diskon (Opsional)</label>
                    <input type="text" name="kode_diskon" class="form-control" placeholder="Masukkan kode diskon">
                  </div>
                </div>
              </div>
            </div>

            <!-- Metode Pembayaran -->
            <div class="card mb-4">
              <div class="card-header">
                <h5><i class="fas fa-credit-card me-2"></i>Metode Pembayaran</h5>
              </div>
              <div class="card-body">
                <input type="hidden" name="metode_pembayaran" id="metode_pembayaran" required>

                <div class="row g-3" id="metode_cards">
                  <div class="col-6">
                    <div class="metode-card" data-metode="mandiri">
                      <img src="../assets/mandiri.png" alt="Mandiri">
                      <div>Bank Mandiri</div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="metode-card" data-metode="bca">
                      <img src="../assets/bca.png" alt="BCA">
                      <div>Bank BCA</div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="metode-card" data-metode="bri">
                      <img src="../assets/bri.png" alt="BRI">
                      <div>Bank BRI</div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="metode-card" data-metode="gopay">
                      <img src="../assets/gopay.png" alt="GoPay">
                      <div>GoPay</div>
                    </div>
                  </div>
                </div>

                <div class="mt-4" id="rekening_info" style="display: none;">
                  <div class="alert alert-info border-0" style="background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%); border: 2px solid #000000 !important;">
                    <h6 class="alert-heading" style="color: #000000;"><i class="fas fa-info-circle me-2"></i>Informasi Pembayaran</h6>
                    <div class="mb-2">
                      <label class="form-label fw-bold" style="color: #000000;">Nomor Rekening / E-Wallet</label>
                      <input type="text" class="form-control" id="nomor_rekening" readonly style="border: 2px solid #333333; background: white; color: #000000;">
                    </div>
                    <small style="color: #333333;">
                      <i class="fas fa-exclamation-triangle me-1"></i>
                      Silakan transfer sesuai total pembayaran ke nomor rekening di atas, lalu upload bukti pembayaran.
                    </small>
                  </div>
                </div>
              </div>
            </div>

            <!-- Total Summary -->
            <div class="total-summary text-center">
              <h4><i class="fas fa-money-check-alt me-2"></i>Total Pembayaran</h4>
              <h2 class="mb-3">Rp<?= number_format($total_harga + $ongkir) ?></h2>
              <button type="submit" class="btn btn-light btn-lg w-100">
                <i class="fas fa-arrow-right me-2"></i>Lanjutkan ke Pembayaran
              </button>
            </div>
          </div>

        </div>
      </form>
    </div>
  </div>


  <script>
    const rekeningInfo = {
      mandiri: '137-00-9876543-1 a.n. Albi Putra Mutdriansyah',
      bca: '7391516859 a.n. Albi Putra Mutdriansyah',
      bri: '4791-0105-8128-536 a.n. Albi Putra Mutdriansyah',
      gopay: '081314215856 a.n. Albi'
    };

    const cards = document.querySelectorAll('.metode-card');
    const rekeningDiv = document.getElementById('rekening_info');
    const rekeningInput = document.getElementById('nomor_rekening');
    const metodeInput = document.getElementById('metode_pembayaran');

    cards.forEach(card => {
      card.addEventListener('click', function() {
        // Hapus pilihan sebelumnya
        cards.forEach(c => c.classList.remove('selected'));
        this.classList.add('selected');

        const metode = this.dataset.metode;
        metodeInput.value = metode;

        if (rekeningInfo[metode]) {
          rekeningDiv.style.display = 'block';
          rekeningInput.value = rekeningInfo[metode];
        } else {
          rekeningDiv.style.display = 'none';
          rekeningInput.value = '';
        }
      });
    });
  </script>

</body>

</html>