<?php
require '../config.php';
session_start();
require 'navbar.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$query = mysqli_query($conn, "SELECT * FROM pengguna WHERE id = $user_id");
$user = mysqli_fetch_assoc($query);

if ($user['peran'] !== 'pelanggan') {
    echo "Akses ditolak!";
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kontak - Day Apparel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            color: #333;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .contact-container {
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            padding: 0;
            margin-top: 20px;
            margin-bottom: 20px;
            overflow: hidden;
        }

        .contact-header {
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            color: white;
            padding: 2rem 1.5rem;
            text-align: center;
            position: relative;
        }

        .contact-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="white" opacity="0.1"/><circle cx="80" cy="30" r="1.5" fill="white" opacity="0.15"/><circle cx="40" cy="70" r="1" fill="white" opacity="0.1"/><circle cx="90" cy="80" r="2.5" fill="white" opacity="0.08"/></svg>');
            pointer-events: none;
        }

        .contact-header h1 {
            font-size: 1.8rem;
            font-weight: 300;
            margin-bottom: 0.8rem;
            position: relative;
            z-index: 1;
        }

        .contact-header p {
            font-size: 1rem;
            opacity: 0.9;
            position: relative;
            z-index: 1;
            margin-bottom: 0;
        }

        .contact-content {
            padding: 1.5rem;
        }

        .contact-card {
            background: #fff;
            border: 1px solid #e9ecef;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
            height: auto;
        }

        .contact-card:hover {
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .contact-card .icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.3rem;
            margin-bottom: 1rem;
            margin-left: auto;
            margin-right: auto;
        }

        .contact-card h3 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 1rem;
            font-size: 1.2rem;
            text-align: center;
        }

        .contact-card p {
            color: #6c757d;
            line-height: 1.6;
            margin-bottom: 1.5rem;
            text-align: center;
            font-size: 0.95rem;
        }

        .contact-number {
            margin-bottom: 1rem;
            text-align: center; 
        }

        .whatsapp-btn {
            background: linear-gradient(135deg, #25d366 0%, #128c7e 100%);
            color: white;
            border: none;
            border-radius: 12px;
            padding: 1rem 1.5rem;
            font-size: 1rem;
            text-decoration: none;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(37, 211, 102, 0.3);
            width: 100%;
            max-width: 280px;
            margin: 0 auto;
        }

        .whatsapp-btn:hover {
            background: linear-gradient(135deg, #128c7e 0%, #075e54 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(37, 211, 102, 0.4);
            color: white;
            text-decoration: none;
        }

        .whatsapp-btn .number-text {
            font-size: 1.1rem;
            font-weight: 600;
            color: white;
            letter-spacing: 1px;
        }

        .whatsapp-btn small {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.85rem;
        }

        .feature-list {
            list-style: none;
            padding: 0;
            margin-top: 1.5rem;
        }

        .feature-list li {
            display: flex;
            align-items: center;
            padding: 0.75rem 0;
            color: #495057;
            border-bottom: 1px solid #f1f3f4;
            font-size: 0.9rem;
        }

        .feature-list li:last-child {
            border-bottom: none;
        }

        .feature-list li i {
            color: #28a745;
            margin-right: 0.75rem;
            width: 20px;
            flex-shrink: 0;
        }

        .info-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
        }

        .info-card h4 {
            color: #2c3e50;
            margin-bottom: 0.8rem;
            font-size: 1.1rem;
        }

        .info-card p {
            color: #6c757d;
            margin-bottom: 0;
            font-size: 0.9rem;
            line-height: 1.5;
        }

        .toast-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            left: 20px;
            background: #28a745;
            color: white;
            padding: 1rem 1.5rem;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            transform: translateY(-100px);
            transition: transform 0.3s ease;
            z-index: 9999;
            text-align: center;
        }

        .toast-notification.show {
            transform: translateY(0);
        }

        .map-container {
            position: relative;
            width: 100%;
            height: 250px;
            border-radius: 12px;
            overflow: hidden;
            margin-top: 1.5rem;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .map-info{
            margin-top: 1rem;
        }

        .info-item {
            display: flex;
            align-items: center;
            margin-bottom: 0.8rem;
            font-size: 0.9rem;
            padding: 0.5rem;
            background: #f8f9fa;
            border-radius: 8px;
        }

        .info-item i {
            flex-shrink: 0;
             margin-right: 0.5rem;
            width: 20px;
        }

        /* Mobile-specific optimizations */
        @media (max-width: 768px) {
            .container {
                padding-left: 10px;
                padding-right: 10px;
            }
            .contact-container {
                margin-top: 15px;
                margin-bottom: 15px;
                border-radius: 8px;
            }
            .contact-header {
                padding: 1.5rem 1rem;
                border-radius: 8px 8px 0 0;
            }
            .contact-header h1 {
                font-size: 1.6rem;
            }
            .contact-header p {
                font-size: 0.9rem;
            }
            .contact-content {
                padding: 1rem;
            }
            .contact-card {
                padding: 1.25rem;
                margin-bottom: 1.25rem;
                border-radius: 8px;
            }
            .contact-card .icon {
                width: 45px;
                height: 45px;
                font-size: 1.2rem;
            }
            .contact-card h3 {
                font-size: 1.1rem;
            }
            .contact-card p {
                font-size: 0.9rem;
            }
            .whatsapp-btn {
                padding: 0.875rem 1.25rem;
                font-size: 0.95rem;
                max-width: 100%;
            }
            .whatsapp-btn .number-text {
                font-size: 1rem;
            }
            .feature-list li {
                font-size: 0.85rem;
                padding: 0.6rem 0;
            }
            .info-card {
                padding: 1.25rem;
            }
            .info-card h4 {
                font-size: 1rem;
            }
            .info-card p {
                font-size: 0.85rem;
            }
            .map-container {
                height: 200px;
            }
            .info-item {
                font-size: 0.85rem;
                padding: 0.4rem;
                margin-bottom: 0.6rem;
            }
            .info-item i {
                margin-right: 0.4rem;
            }
            .toast-notification {
                left: 10px;
                right: 10px;
                font-size: 0.9rem;
            }
        }
        @media (max-width: 480px) {
            .contact-header h1 {
                font-size: 1.4rem;
            }
            .contact-header p {
                font-size: 0.85rem;
            }
            .contact-card {
                padding: 1rem;
            }
            .contact-card .icon {
                width: 40px;
                height: 40px;
                font-size: 1.1rem;
            }
            .contact-card h3 {
                font-size: 1rem;
            }
            .whatsapp-btn {
                padding: 0.75rem 1rem;
            }
            .whatsapp-btn .number-text {
                font-size: 0.95rem;
            }
            .map-container {
                height: 180px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="contact-container">
            <div class="contact-header">
                <h1><i class="fas fa-headset me-2"></i>Hubungi Kami</h1>
                <p>Tim customer service Day Apparel siap membantu Anda kapan saja</p>
            </div>

            <div class="contact-content">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="contact-card">
                            <div class="icon">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <h3>Customer Service 24/7</h3>
                            <p>
                                Butuh bantuan dengan pesanan Anda? Punya pertanyaan tentang produk?
                                Tim customer service kami tersedia 24 jam sehari, 7 hari seminggu untuk membantu Anda.
                            </p>

                            <div class="contact-number">
                                <a href="https://wa.me/6281314215856" target="_blank" class="whatsapp-btn">
                                    <i class="fab fa-whatsapp me-2"></i>
                                    <span class="number-text">0813-1421-5856</span>
                                </a>
                            </div>

                            <ul class="feature-list">
                                <li>
                                    <i class="fas fa-check-circle"></i>
                                    <span>Layanan pelanggan 24/7</span>
                                </li>
                                <li>
                                    <i class="fas fa-check-circle"></i>
                                    <span>Tracking status pesanan</span>
                                </li>
                                <li>
                                    <i class="fas fa-check-circle"></i>
                                    <span>Bantuan pembayaran dan pengiriman</span>
                                </li>
                                <li>
                                    <i class="fas fa-check-circle"></i>
                                    <span>Konsultasi produk dan ukuran</span>
                                </li>
                                <li>
                                    <i class="fas fa-check-circle"></i>
                                    <span>Penanganan komplain dan retur</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="contact-card">
                            <div class="icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <h3>Jam Operasional</h3>
                            <p>Kami melayani Anda setiap hari tanpa henti:</p>
                            <div class="info-card">
                                <h4>24 Jam / 7 Hari</h4>
                                <p>Senin - Minggu<br>00:00 - 24:00 WIB</p>
                            </div>
                        </div>

                        <div class="contact-card">
                            <div class="icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <h3>Lokasi Toko</h3>
                            <p>Kunjungi toko offline kami untuk pengalaman belanja yang lebih personal.</p>
                            <div class="info-card">
                                <h4>Day Apparel Store</h4>
                                <p>Jl. Kusuma Timur III c no 32, Ampera<br>Kota Bekasi, Jawa Barat 17111<br>Indonesia</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Google Maps Section -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="contact-card">
                            <div class="icon">
                                <i class="fas fa-map"></i>
                            </div>
                            <h3>Peta Lokasi</h3>
                            <p>Temukan kami di pusat kota Bekasi. Mudah dijangkau dengan transportasi umum maupun kendaraan pribadi.</p>

                            <div class="map-container" style="position: relative; width: 100%; height: 400px; border-radius: 12px; overflow: hidden; margin-top: 1.5rem; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                                <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d8904.871841873266!2d107.02258421252039!3d-6.241951433550057!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sid!2sid!4v1752834648205!5m2!1sid!2sid"
                                    width="100%"
                                    height="400"
                                    style="border:0;"
                                    allowfullscreen=""
                                    loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade">
                                </iframe>
                            </div>

                            <div class="map-info mt-3">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="info-item">
                                            <i class="fas fa-car text-primary me-2"></i>
                                            <span><strong>Parkir:</strong> Tersedia area parkir</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="info-item">
                                            <i class="fas fa-bus text-primary me-2"></i>
                                            <span><strong>TransJakarta:</strong> Halte Bekasi Timur</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="info-item">
                                            <i class="fas fa-subway text-primary me-2"></i>
                                            <span><strong>KRL</strong> Stasiun Bekasi Timur</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include '../footer.php'; ?>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

        <script>
            function copyToClipboard(text) {
                navigator.clipboard.writeText(text).then(function() {
                    showToast('Nomor berhasil disalin ke clipboard!');
                }).catch(function(err) {
                    // Fallback for older browsers
                    const textArea = document.createElement('textarea');
                    textArea.value = text;
                    document.body.appendChild(textArea);
                    textArea.select();
                    try {
                        document.execCommand('copy');
                        showToast('Nomor berhasil disalin ke clipboard!');
                    } catch (err) {
                        showToast('Gagal menyalin nomor');
                    }
                    document.body.removeChild(textArea);
                });
            }

            function showToast(message) {
                // Remove existing toast if any
                const existingToast = document.querySelector('.toast-notification');
                if (existingToast) {
                    existingToast.remove();
                }

                // Create new toast
                const toast = document.createElement('div');
                toast.className = 'toast-notification';
                toast.innerHTML = `<i class="fas fa-check-circle me-2"></i>${message}`;
                document.body.appendChild(toast);

                // Show toast
                setTimeout(() => toast.classList.add('show'), 100);

                // Hide and remove toast
                setTimeout(() => {
                    toast.classList.remove('show');
                    setTimeout(() => toast.remove(), 300);
                }, 3000);
            }

            // Add some interactive effects
            document.querySelectorAll('.contact-card').forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.borderColor = '#2c3e50';
                });

                card.addEventListener('mouseleave', function() {
                    this.style.borderColor = '#e9ecef';
                });
            });
        </script>
</body>

</html>