<?php
// Ensure session is started only once
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<style>
    /* Minimalist Navbar Styling */
    .navbar-minimal {
        background-color: #ffffff;
        /* White background */
        border-bottom: 1px solid #e0e0e0;
        /* Subtle bottom border */
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        /* Light shadow for depth */
        padding-top: 0.8rem;
        padding-bottom: 0.8rem;
    }

    .navbar-minimal .navbar-brand {
        font-weight: 700;
        /* Bold brand name */
        font-size: 1.4rem;
        color: #333;
        /* Darker brand text */
        letter-spacing: -0.5px;
        /* Slightly tighter letter spacing */
    }

    .navbar-minimal .nav-link {
        color: #555;
        /* Muted link color */
        font-weight: 500;
        padding: 0.5rem 1rem;
        /* Adjust padding for links */
        transition: color 0.2s ease-in-out, background-color 0.2s ease-in-out;
        border-radius: 6px;
        /* Slightly rounded corners for active/hover states */
    }

    .navbar-minimal .nav-link:hover {
        color: #000;
        /* Darker on hover */
        background-color: #f0f0f0;
        /* Subtle background on hover */
    }

    .navbar-minimal .nav-link.active {
        color: #000;
        /* Active link is black */
        background-color: #f0f0f0;
        /* Active link has a subtle background */
        font-weight: 600;
        /* Slightly bolder for active */
    }

    /* Buttons in Navbar */
    .navbar-minimal .btn-outline-dark-custom {
        color: #333;
        border-color: #333;
        font-weight: 500;
        padding: 0.4rem 1rem;
        /* Adjust button padding */
        border-radius: 6px;
        /* Rounded button corners */
        transition: all 0.2s ease-in-out;
    }

    .navbar-minimal .btn-outline-dark-custom:hover {
        background-color: #333;
        color: #fff;
    }

    /* Adjust toggler icon color for light background */
    .navbar-minimal .navbar-toggler-icon {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2851, 51, 51, 0.7%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
    }

    .navbar-minimal .navbar-toggler {
        border-color: rgba(51, 51, 51, 0.1);
        /* Lighter border for toggler */
    }

    /* Spacing for mobile buttons */
    @media (max-width: 991.98px) {
        .navbar-minimal .d-flex {
            margin-top: 1rem;
            /* Space for buttons below nav items on mobile */
            flex-direction: column;
            /* Stack buttons vertically on mobile */
            align-items: stretch;
            /* Make buttons full width */
        }

        .navbar-minimal .d-flex .btn {
            margin-bottom: 0.5rem;
            /* Space between stacked buttons */
            margin-right: 0 !important;
            /* Remove horizontal margin */
        }
    }
    
     @media (max-width: 768px) {
        .navbar,
        .navbar-minimal,
        .navbar-brand,
        .navbar-nav {
            font-size: 1rem !important;
            padding-top: 0.5rem !important;
            padding-bottom: 0.5rem !important;
            min-height: 56px !important;
        }
        .navbar-minimal .navbar-brand {
            font-size: 1.4rem !important;
            padding-top: 0.25rem !important;
            padding-bottom: 0.25rem !important;
        }
    }
</style>

<nav class="navbar navbar-expand-lg navbar-minimal">
    <div class="container-fluid">
        <a class="navbar-brand" href="/day.apparel/index.php">
            <img src="/day.apparel/assets/day.apparel.jpeg" alt="Logo" style="height: 60px;">
            Day.Apparel
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarPelanggan" aria-controls="navbarPelanggan" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarPelanggan">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'index.php' || basename($_SERVER['PHP_SELF']) == '' ? ' active' : '' ?>" href="/day.apparel/index.php">Beranda</a>
                    </li>
                    <!--
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? ' active' : '' ?>" href="/day.apparel/pelanggan/dashboard.php">Dashboard</a>
                    </li>
                    -->
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'profile.php' ? ' active' : '' ?>" href="/day.apparel/pelanggan/profile.php">Profil</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'kontak.php' ? ' active' : '' ?>" href="/day.apparel/pelanggan/kontak.php">Kontak</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'keranjang.php' ? ' active' : '' ?>" href="/day.apparel/pelanggan/keranjang.php">Keranjang</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link<?= basename($_SERVER['PHP_SELF']) == 'riwayat.php' ? ' active' : '' ?>" href="/day.apparel/pelanggan/riwayat.php">Riwayat</a>
                    </li>
                <?php endif; ?>
            </ul>

            <div class="d-flex">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <a href="/day.apparel/logout.php" class="btn btn-outline-dark-custom">Logout</a>
                <?php else: ?>
                    <a href="/day.apparel/login.php" class="btn btn-outline-dark-custom me-2">Login</a>
                    <a href="/day.apparel/register.php" class="btn btn-outline-dark-custom">Register</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>