<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$produk_id = $_POST['produk_id'];
$ukuran_id = $_POST['ukuran_id']; // Pastikan ini ditangkap
$jumlah = $_POST['jumlah'];
$pengguna_id = $_SESSION['user_id'];

// Validasi dasar
if (!$ukuran_id || !$jumlah || !$produk_id) {
  $_SESSION['error'] = 'Data tidak lengkap. Silakan pilih ukuran dan jumlah.';
  header("Location: ../detail_produk.php?id=" . $produk_id);
  exit;
}


// Cek stok sesuai ukuran
$cekStok = $conn->prepare("SELECT stok FROM ukuran_produk WHERE id = ?");
$cekStok->bind_param("i", $ukuran_id);
$cekStok->execute();
$cekStokResult = $cekStok->get_result()->fetch_assoc();

if (!$cekStokResult) {
  $_SESSION['error'] = 'Ukuran produk tidak ditemukan.';
  header("Location: ../detail_produk.php?id=" . $produk_id);
  exit;
}

if ($cekStokResult['stok'] <= 0) {
  $_SESSION['error'] = 'Produk dengan ukuran ini sedang tidak tersedia (stok habis).';
  header("Location: ../detail_produk.php?id=" . $produk_id);
  exit;
}

if ($cekStokResult['stok'] < $jumlah) {
  $_SESSION['error'] = 'Stok tidak mencukupi. Stok tersedia: ' . $cekStokResult['stok'];
  header("Location: ../detail_produk.php?id=" . $produk_id);
  exit;
}

// Insert ke keranjang
$stmt = $conn->prepare("INSERT INTO keranjang (pengguna_id, produk_id, ukuran_id, jumlah) VALUES (?, ?, ?, ?)");
$stmt->bind_param("iiii", $pengguna_id, $produk_id, $ukuran_id, $jumlah);
$stmt->execute();

header("Location: keranjang.php");
