<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}

$user_id = $_SESSION['user_id'];
$total_harga = (int)$_POST['total_harga'];
$ongkir = 20000;
$kode_diskon = trim($_POST['kode_diskon'] ?? '');
$diskon = 0;
$metode_pembayaran = $_POST['metode_pembayaran'] ?? '';

// Cek diskon aktif
if ($kode_diskon !== '') {
  $cek_diskon = mysqli_query($conn, "SELECT * FROM diskon WHERE nama_diskon = '$kode_diskon' AND aktif = 'ya'");
  if (mysqli_num_rows($cek_diskon) > 0) {
    $d = mysqli_fetch_assoc($cek_diskon);
    $diskon = ($d['persen'] / 100) * $total_harga;
  }
}

$grand_total = $total_harga - $diskon + $ongkir;

// Upload bukti pembayaran
$bukti_path = null;
if (isset($_FILES['bukti_pembayaran']) && $_FILES['bukti_pembayaran']['error'] === 0) {
  $file_tmp = $_FILES['bukti_pembayaran']['tmp_name'];
  $file_name = uniqid() . '_' . $_FILES['bukti_pembayaran']['name'];
  $file_dest = '../upload/' . $file_name;

  $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
  if (in_array($_FILES['bukti_pembayaran']['type'], $allowed_types)) {
    move_uploaded_file($file_tmp, $file_dest);
    $bukti_path = $file_name;
  }
}

if (empty($metode_pembayaran)) {
  echo "<script>alert('Silakan pilih metode pembayaran.'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
  exit;
}

// Tentukan status berdasarkan bukti pembayaran
$status = $bukti_path ? 'dibayar' : 'menunggu';

// Simpan transaksi
$insert_transaksi = "INSERT INTO transaksi 
  (pengguna_id, total_harga, ongkos_kirim, metode_pembayaran, status, dibuat_pada, bukti_pembayaran) 
  VALUES (
    $user_id,
    $grand_total,
    $ongkir,
    '$metode_pembayaran',
    '$status',
    NOW(),
    " . ($bukti_path ? "'$bukti_path'" : "NULL") . "
  )";

$result_transaksi = mysqli_query($conn, $insert_transaksi);

if (!$result_transaksi) {
  echo "<script>alert('Error menyimpan transaksi: " . mysqli_error($conn) . "'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
  exit;
}

$transaksi_id = mysqli_insert_id($conn);

// Ambil isi keranjang
$keranjang_query = "
  SELECT k.*, p.harga, up.stok AS stok_ukuran, up.ukuran
  FROM keranjang k
  JOIN produk p ON k.produk_id = p.id
  JOIN ukuran_produk up ON k.ukuran_id = up.id
  WHERE k.pengguna_id = $user_id
";

$keranjang = mysqli_query($conn, $keranjang_query);

if (!$keranjang) {
  echo "<script>alert('Error mengambil data keranjang: " . mysqli_error($conn) . "'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
  exit;
}

$keranjang_count = mysqli_num_rows($keranjang);

if ($keranjang_count == 0) {
  // Rollback transaksi jika keranjang kosong
  mysqli_query($conn, "DELETE FROM transaksi WHERE id = $transaksi_id");
  echo "<script>alert('Keranjang kosong. Tidak dapat melakukan checkout.'); window.location.href='/day.apparel/pelanggan/keranjang.php';</script>";
  exit;
}

$gagal_stok = false;
$detail_inserted = 0;

while ($item = mysqli_fetch_assoc($keranjang)) {
  $produk_id = $item['produk_id'];
  $ukuran_id = $item['ukuran_id'];
  $jumlah = $item['jumlah'];
  $stok = $item['stok_ukuran'];
  $subtotal = $item['harga'] * $jumlah;

  if ($stok < $jumlah) {
    $gagal_stok = true;
    break;
  }

  // Simpan detail transaksi dengan ukuran_id
  $insert_detail = "INSERT INTO transaksi_detail (transaksi_id, produk_id, ukuran_id, jumlah, subtotal)
    VALUES ($transaksi_id, $produk_id, $ukuran_id, $jumlah, $subtotal)";

  $result_detail = mysqli_query($conn, $insert_detail);

  if (!$result_detail) {
    echo "<script>alert('Error menyimpan detail transaksi: " . mysqli_error($conn) . "'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
    exit;
  }

  $detail_inserted++;

  // Kurangi stok dari ukuran_produk dengan validasi tidak minus
  $update_stok = "UPDATE ukuran_produk SET stok = GREATEST(0, stok - $jumlah) WHERE id = $ukuran_id AND stok >= $jumlah";
  $result_stok = mysqli_query($conn, $update_stok);

  if (!$result_stok || mysqli_affected_rows($conn) == 0) {
    echo "<script>alert('Error mengurangi stok atau stok tidak mencukupi: " . mysqli_error($conn) . "'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
    exit;
  }
}

if ($gagal_stok) {
  // Rollback jika stok tidak cukup
  mysqli_query($conn, "DELETE FROM transaksi WHERE id = $transaksi_id");
  mysqli_query($conn, "DELETE FROM transaksi_detail WHERE transaksi_id = $transaksi_id");

  if ($bukti_path && file_exists("../upload/$bukti_path")) {
    unlink("../upload/$bukti_path");
  }

  echo "<script>alert('Stok salah satu produk tidak mencukupi.'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
  exit;
}

// Verifikasi detail transaksi berhasil disimpan
if ($detail_inserted == 0) {
  // Rollback transaksi jika tidak ada detail yang tersimpan
  mysqli_query($conn, "DELETE FROM transaksi WHERE id = $transaksi_id");
  if ($bukti_path && file_exists("../upload/$bukti_path")) {
    unlink("../upload/$bukti_path");
  }
  echo "<script>alert('Error: Tidak ada detail transaksi yang berhasil disimpan. Transaksi dibatalkan.'); window.location.href='/day.apparel/pelanggan/checkout.php';</script>";
  exit;
}

// Bersihkan keranjang
$clear_keranjang = mysqli_query($conn, "DELETE FROM keranjang WHERE pengguna_id = $user_id");

if (!$clear_keranjang) {
  echo "<script>alert('Warning: Transaksi berhasil, tetapi gagal membersihkan keranjang.'); window.location.href='/day.apparel/pelanggan/riwayat.php';</script>";
  exit;
}

// Redirect
header("Location: /day.apparel/pelanggan/riwayat.php");
exit;
