<?php
require '../config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$transaksi_id = (int)$_POST['transaksi_id'];
$produk_id = (int)$_POST['produk_id'];
$rating = (int)$_POST['rating'];
$komentar = trim($_POST['komentar']);

// Validasi input
if ($transaksi_id <= 0 || $produk_id <= 0 || $rating < 1 || $rating > 5) {
    $_SESSION['error'] = 'Data review tidak valid.';
    header("Location: detail_transaksi.php?id=" . $transaksi_id);
    exit;
}

// Cek apakah transaksi ini milik user dan sudah selesai
$stmt_check = $conn->prepare("
    SELECT t.*, td.id as detail_id 
    FROM transaksi t 
    JOIN transaksi_detail td ON t.id = td.transaksi_id 
    WHERE t.id = ? AND t.pengguna_id = ? AND td.produk_id = ? AND t.status = 'selesai'
");
$stmt_check->bind_param("iii", $transaksi_id, $user_id, $produk_id);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows == 0) {
    $_SESSION['error'] = 'Anda tidak dapat memberikan review untuk transaksi ini.';
    header("Location: detail_transaksi.php?id=" . $transaksi_id);
    exit;
}

// Cek apakah sudah pernah review produk ini di transaksi ini
$stmt_existing = $conn->prepare("
    SELECT id FROM ulasan_produk 
    WHERE id_produk = ? AND id_pelanggan = ?
");
$stmt_existing->bind_param("ii", $produk_id, $user_id);
$stmt_existing->execute();
$existing_result = $stmt_existing->get_result();

if ($existing_result->num_rows > 0) {
    $_SESSION['error'] = 'Anda sudah memberikan review untuk produk ini.';
    header("Location: detail_transaksi.php?id=" . $transaksi_id);
    exit;
}

// Simpan review
$stmt_insert = $conn->prepare("
    INSERT INTO ulasan_produk (id_produk, id_pelanggan, rating, isi_ulasan, tanggal_ulasan, status) 
    VALUES (?, ?, ?, ?, NOW(), 'pending')
");
$stmt_insert->bind_param("iiis", $produk_id, $user_id, $rating, $komentar);

if ($stmt_insert->execute()) {
    $_SESSION['success'] = 'Review berhasil dikirim dan akan ditinjau oleh admin.';
} else {
    $_SESSION['error'] = 'Gagal menyimpan review. Silakan coba lagi.';
}

header("Location: detail_transaksi.php?id=" . $transaksi_id);
exit;
