<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register - Day Apparel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container-fluid vh-100 d-flex align-items-center justify-content-center">
  <div class="row w-100 justify-content-center">
    <div class="col-11 col-sm-8 col-md-6 col-lg-4 col-xl-3">
      
      <!-- Brand Logo/Name -->
      <div class="text-center mb-4">
        <h2 class="fw-bold text-dark mb-1">Day Apparel</h2>
        <p class="text-muted small">Buat akun baru Anda</p>
      </div>

      <!-- Alert Messages -->
      <div id="alert-container">
        <?php if (isset($_GET['pesan']) && $_GET['pesan'] == 'gagal'): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>Email sudah terdaftar!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>
        <?php endif; ?>
      </div>

      <!-- Register Card -->
      <div class="card border-0 shadow-sm">
        <div class="card-body p-4">
          
          <form action="../day.apparel/proses/proses_pelanggan_register.php" method="POST" id="registerForm">
            
            <!-- Nama Input -->
            <div class="mb-3">
              <label for="nama" class="form-label fw-medium text-dark">Nama Lengkap</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-user text-muted"></i>
                </span>
                <input type="text" 
                       name="nama" 
                       id="nama"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Masukkan nama lengkap Anda"
                       required>
              </div>
            </div>

            <!-- Email Input -->
            <div class="mb-3">
              <label for="email" class="form-label fw-medium text-dark">Email</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-envelope text-muted"></i>
                </span>
                <input type="email" 
                       name="email" 
                       id="email"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Masukkan email Anda"
                       required>
              </div>
              <div class="form-text text-muted small">
                <i class="fas fa-info-circle me-1"></i>Pastikan email yang Anda masukkan aktif
              </div>
            </div>

            <!-- Password Input -->
            <div class="mb-4">
              <label for="password" class="form-label fw-medium text-dark">Password</label>
              <div class="input-group">
                <span class="input-group-text bg-light border-end-0">
                  <i class="fas fa-lock text-muted"></i>
                </span>
                <input type="password" 
                       name="password" 
                       id="password"
                       class="form-control border-start-0 ps-0" 
                       placeholder="Buat password yang kuat"
                       required
                       minlength="6">
                <button class="btn btn-outline-secondary border-start-0" 
                        type="button" 
                        id="togglePassword">
                  <i class="fas fa-eye" id="eyeIcon"></i>
                </button>
              </div>
              <div class="form-text text-muted small">
                <i class="fas fa-shield-alt me-1"></i>Minimal 6 karakter
              </div>
            </div>

            <!-- Terms and Conditions -->
            <div class="mb-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="terms" required>
                <label class="form-check-label small text-muted" for="terms">
                  Saya setuju dengan <a href="#" class="text-decoration-none">Syarat & Ketentuan</a> 
                  dan <a href="#" class="text-decoration-none">Kebijakan Privasi</a>
                </label>
              </div>
            </div>

            <!-- Register Button -->
            <div class="d-grid mb-3">
              <button type="submit" class="btn btn-dark py-2 fw-medium">
                <i class="fas fa-user-plus me-2"></i>Daftar Sekarang
              </button>
            </div>

          </form>

          <!-- Divider -->
          <div class="text-center mb-3">
            <hr class="my-3">
          </div>

          <!-- Action Links -->
          <div class="text-center">
            <p class="mb-0">
              <a href="../day.apparel/login.php" 
                 class="text-decoration-none fw-medium">
                Sudah punya akun? <span class="text-primary">Masuk di sini</span>
              </a>
            </p>
          </div>

        </div>
      </div>

      <!-- Footer -->
      <div class="text-center mt-4">
        <p class="text-muted small mb-0">
          © 2025 Day Apparel. All rights reserved.
        </p>
      </div>

    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom JavaScript -->
<script>
// Toggle Password Visibility
document.getElementById('togglePassword').addEventListener('click', function () {
  const password = document.getElementById('password');
  const eyeIcon = document.getElementById('eyeIcon');
  
  if (password.type === 'password') {
    password.type = 'text';
    eyeIcon.classList.remove('fa-eye');
    eyeIcon.classList.add('fa-eye-slash');
  } else {
    password.type = 'password';
    eyeIcon.classList.remove('fa-eye-slash');
    eyeIcon.classList.add('fa-eye');
  }
});

// Form Validation Enhancement
document.getElementById('registerForm').addEventListener('submit', function(e) {
  const password = document.getElementById('password').value;
  const terms = document.getElementById('terms').checked;
  
  if (password.length < 6) {
    e.preventDefault();
    alert('Password harus minimal 6 karakter!');
    return false;
  }
  
  if (!terms) {
    e.preventDefault();
    alert('Anda harus menyetujui Syarat & Ketentuan!');
    return false;
  }
});

// Real-time password strength indicator
document.getElementById('password').addEventListener('input', function() {
  const password = this.value;
  const strength = document.getElementById('passwordStrength');
  
  if (password.length === 0) {
    // Hide strength indicator when empty
    return;
  }
  
  // Simple password strength check
  let score = 0;
  if (password.length >= 6) score++;
  if (password.match(/[a-z]/)) score++;
  if (password.match(/[A-Z]/)) score++;
  if (password.match(/[0-9]/)) score++;
  if (password.match(/[^a-zA-Z0-9]/)) score++;
  
  // Visual feedback could be added here if needed
});

// Auto-capitalize name input
document.getElementById('nama').addEventListener('input', function() {
  this.value = this.value.replace(/\b\w/g, l => l.toUpperCase());
});
</script>

</body>
</html>